/***************************************************************************

	Nemesis (Hacked?)		GX400
	Nemesis (UK)			GX400
	Twin Bee				GX412
	Gradius					GX456
	Galactic Warriors		GX578
	Konami GT				GX561
	RF2						GX561
	Salamander				GX587
	Lifeforce (US)			GX587
	Lifeforce (Japan)		GX587

To do:
	Combine video functions for Salamander/other games.
	Implement sprite/background priority and background/background priority
	  (lifefrcj title screen, Nemesis later levels).
	Speech in Salamander, K007232 stuff isn't verified.
	Possible missing sound channel in Nemesis?
	Colours in Nemesis/GX400 are calculated wrong.  They are far too bright.
	Colours in Salamander are fine...
	Clean up stuff :)
	Input ports are slightly different between Salamander/Lifeforce.
	Lifeforce (Japan) needs support for the large sprite size.

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "sndhrdw/k007232.h"
#include "z80/z80.h"

static unsigned char *ram;

extern unsigned char *nemesis_videoram1;
extern unsigned char *nemesis_videoram2;
extern unsigned char *nemesis_characterram;
extern unsigned char *nemesis_xscroll1,*nemesis_xscroll2, *nemesis_yscroll;
extern int  nemesis_characterram_size;

int  nemesis_videoram1_r(int offset);
void nemesis_videoram1_w(int offset,int data);
int  nemesis_videoram2_r(int offset);
void nemesis_videoram2_w(int offset,int data);
int  nemesis_characterram_r(int offset);
void nemesis_characterram_w(int offset,int data);
void nemesis_vh_screenrefresh(struct osd_bitmap *bitmap,int full_refresh);
int  nemesis_vh_start(void);
void nemesis_vh_stop(void);

void salamand_vh_screenrefresh(struct osd_bitmap *bitmap,int full_refresh);
void nemesis_init_machine(void);

void salamander_palette_w(int offset,int data);


void gx400_xscroll1_w(int offset,int data);
void gx400_xscroll2_w(int offset,int data);
void gx400_yscroll_w(int offset,int data);
int  gx400_xscroll1_r(int offset);
int  gx400_xscroll2_r(int offset);
int  gx400_yscroll_r(int offset);

extern unsigned char *nemesis_yscroll1, *nemesis_yscroll2;


void nemesis_palette_w(int offset,int data);

int irq_on = 0;
int irq1_on = 0;
int irq2_on = 0;
int irq4_on = 0;


void nemesis_init_machine(void)
{
	irq_on = 0;
	irq1_on = 0;
	irq2_on = 0;
	irq4_on = 0;
}



int nemesis_interrupt(void)
{
	if (irq_on) return 1;

	return 0;
}

void salamand_soundlatch_w (int offset, int data)
{
	soundlatch_w(offset,data & 0xff);
	cpu_cause_interrupt(1,Z80_IRQ_INT);
}
int konamigt_interrupt(void)
{
	if (cpu_getiloops() == 0)
	{
		if (irq_on)	return 1;
	}
	else
	{
		if (irq2_on) return 2;
	}

	return 0;
}


int gx400_interrupt(void)
{
	switch (cpu_getiloops())
	{
		case 0:
			if (irq1_on) return 1;
			break;

		case 1:
			if (irq2_on) return 2;
			break;

		case 2:
			if (irq4_on) return 4;
			break;
	}

	return 0;
}

void gx400_irq1_enable_w(int offset,int data)
{
	if ((data & 0x00ff0000) == 0)
		irq1_on = data & 0x0001;
}

void gx400_irq2_enable_w(int offset,int data)
{
	if ((data & 0x00ff0000) == 0)
		irq2_on = data & 0x0001;
}

void gx400_irq4_enable_w(int offset,int data)
{
	if ((data & 0xff000000) == 0)
		irq4_on = data & 0x0100;
}

static unsigned char *gx400_shared_ram;


int gx400_sharedram_nosoundfix_r(int offset)
{
	return 2;
}

int gx400_sharedram_r(int offset)
{
	return gx400_shared_ram[offset / 2];
}

void gx400_sharedram_w(int offset,int data)
{
	gx400_shared_ram[offset / 2] = data;
}



int salamand_interrupt(void)
{
	if (irq_on)
		return(1);
	else
		return(0);
}

void nemesis_irq_enable_w(int offset,int data)
{
	irq_on = data & 0xff;
}

void konamigt_irq_enable_w(int offset,int data)
{
	if ((data & 0x00ff0000) == 0)
	{
		irq_on = data & 0xff;
	}
}
void konamigt_irq2_enable_w(int offset,int data)
{
	if ((data & 0x00ff0000) == 0)
	{
		irq2_on = data & 0xff;
	}
}

int konamigt_input_r(int offset)
{
	int data=readinputport(1);
	int data2=readinputport(6);

	int ret=0;

	if(data&0x10) ret|=0x0800;			
	if(data&0x80) ret|=0x0400;			
	if(data&0x20) ret|=0x0300;			

	if(data&0x40) ret|=0xf000;			

	ret|=data2&0x7f;					

	return ret;
}

void nemesis_soundlatch_w (int offset, int data)
{
	soundlatch_w(offset,data & 0xff);

	/* the IRQ should probably be generated by 5e004, but we'll handle it here for now */
	cpu_cause_interrupt(1,0xff);
}

static int nemesis_portA_r(int offset)
{
	#define TIMER_RATE 1024

	return cpu_gettotalcycles() / TIMER_RATE;
}



static struct MemoryReadAddress readmem[] =
{
	{ 0x000000, 0x03ffff, MRA_ROM },
	{ 0x040000, 0x04ffff, nemesis_characterram_r },
	{ 0x050000, 0x0503ff, MRA_BANK1 },
	{ 0x050400, 0x0507ff, MRA_BANK2 },
	{ 0x050800, 0x050bff, MRA_BANK3 },
	{ 0x050c00, 0x050fff, MRA_BANK4 },

	{ 0x052000, 0x053fff, nemesis_videoram1_r },
	{ 0x054000, 0x055fff, nemesis_videoram2_r },
	{ 0x056000, 0x056fff, MRA_BANK5 },
	{ 0x05a000, 0x05afff, paletteram_word_r },

	{ 0x05c400, 0x05c401, input_port_4_r },	/* DSW0 */
	{ 0x05c402, 0x05c403, input_port_5_r },	/* DSW1 */

	{ 0x05cc00, 0x05cc01, input_port_0_r },	/* IN0 */
	{ 0x05cc02, 0x05cc03, input_port_1_r },	/* IN1 */
	{ 0x05cc04, 0x05cc05, input_port_2_r },	/* IN2 */
	{ 0x05cc06, 0x05cc07, input_port_3_r },	/* TEST */

	{ 0x060000, 0x067fff, MRA_BANK6 },
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress writemem[] =
{
	{ 0x000000, 0x03ffff, MWA_ROM },	/* ROM */

	{ 0x040000, 0x04ffff, nemesis_characterram_w, &nemesis_characterram, &nemesis_characterram_size },

	{ 0x050000, 0x0503ff, MWA_BANK1, &nemesis_xscroll1 },
	{ 0x050400, 0x0507ff, MWA_BANK2, &nemesis_xscroll2 },
	{ 0x050800, 0x050bff, MWA_BANK3 },
	{ 0x050c00, 0x050fff, MWA_BANK4, &nemesis_yscroll },
	{ 0x051000, 0x051fff, MWA_NOP },		/* used, but written to with 0's */

	{ 0x052000, 0x053fff, nemesis_videoram1_w, &nemesis_videoram1 },	/* VRAM 1 */
	{ 0x054000, 0x055fff, nemesis_videoram2_w, &nemesis_videoram2 },	/* VRAM 2 */
	{ 0x056000, 0x056fff, MWA_BANK5, &spriteram, &spriteram_size },
	{ 0x05a000, 0x05afff, paletteram_xBBBBBGGGGGRRRRR_word_w, &paletteram },

	{ 0x05c000, 0x05c001, nemesis_soundlatch_w },
	{ 0x05c800, 0x05c801, watchdog_reset_w },	/* probably */

	{ 0x05e000, 0x05e001, &nemesis_irq_enable_w },	/* Nemesis */
	{ 0x05e002, 0x05e003, &nemesis_irq_enable_w },	/* Konami GT */
	{ 0x05e004, 0x05e005, MWA_NOP},	/* bit 8 of the word probably triggers IRQ on sound board */
	{ 0x060000, 0x067fff, MWA_BANK6, &ram },	/* WORK RAM */
	{ -1 }  /* end of table */
};

static struct MemoryReadAddress sound_readmem[] =
{
	{ 0x0000, 0x3fff, MRA_ROM },
	{ 0x4000, 0x47ff, MRA_RAM },
	{ 0xe001, 0xe001, soundlatch_r },
	{ 0xe086, 0xe086, AY8910_read_port_0_r },
	{ 0xe205, 0xe205, AY8910_read_port_1_r },
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress sound_writemem[] =
{
	{ 0x0000, 0x3fff, MWA_ROM },
	{ 0x4000, 0x47ff, MWA_RAM },
	{ 0xe006, 0xe006, AY8910_control_port_0_w },
	{ 0xe106, 0xe106, AY8910_write_port_0_w },
	{ 0xe005, 0xe005, AY8910_control_port_1_w },
	{ 0xe405, 0xe405, AY8910_write_port_1_w },
	{ -1 }  /* end of table */
};


static struct MemoryReadAddress konamigt_readmem[] =
{
	{ 0x000000, 0x03ffff, MRA_ROM },
	{ 0x040000, 0x04ffff, nemesis_characterram_r },
	{ 0x050000, 0x0503ff, MRA_BANK1 },
	{ 0x050400, 0x0507ff, MRA_BANK2 },
	{ 0x050800, 0x050bff, MRA_BANK3 },
	{ 0x050c00, 0x050fff, MRA_BANK4 },

	{ 0x052000, 0x053fff, nemesis_videoram1_r },
	{ 0x054000, 0x055fff, nemesis_videoram2_r },
	{ 0x056000, 0x056fff, MRA_BANK5 },
	{ 0x05a000, 0x05afff, paletteram_word_r },

	{ 0x05c400, 0x05c401, input_port_4_r },	/* DSW0 */
	{ 0x05c402, 0x05c403, input_port_5_r },	/* DSW1 */

	{ 0x05cc00, 0x05cc01, input_port_0_r },	/* IN0 */
	{ 0x05cc02, 0x05cc03, input_port_1_r },	/* IN1 */
	{ 0x05cc04, 0x05cc05, input_port_2_r },	/* IN2 */
	{ 0x05cc06, 0x05cc07, input_port_3_r },	/* TEST */

	{ 0x060000, 0x067fff, MRA_BANK6 },
	{ 0x070000, 0x070001, konamigt_input_r },
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress konamigt_writemem[] =
{
	{ 0x000000, 0x03ffff, MWA_ROM },	/* ROM */

	{ 0x040000, 0x04ffff, nemesis_characterram_w, &nemesis_characterram, &nemesis_characterram_size },

	{ 0x050000, 0x0503ff, MWA_BANK1, &nemesis_xscroll1 },
	{ 0x050400, 0x0507ff, MWA_BANK2, &nemesis_xscroll2 },
	{ 0x050800, 0x050bff, MWA_BANK3 },
	{ 0x050c00, 0x050fff, MWA_BANK4, &nemesis_yscroll },
	{ 0x051000, 0x051fff, MWA_NOP },		/* used, but written to with 0's */

	{ 0x052000, 0x053fff, nemesis_videoram1_w, &nemesis_videoram1 },	/* VRAM 1 */
	{ 0x054000, 0x055fff, nemesis_videoram2_w, &nemesis_videoram2 },	/* VRAM 2 */
	{ 0x056000, 0x056fff, MWA_BANK5, &spriteram, &spriteram_size },
	{ 0x05a000, 0x05afff, paletteram_xBBBBBGGGGGRRRRR_word_w, &paletteram },

	{ 0x05c000, 0x05c001, nemesis_soundlatch_w },
	{ 0x05c800, 0x05c801, watchdog_reset_w },	/* probably */

	{ 0x05e000, 0x05e001, &konamigt_irq2_enable_w },
	{ 0x05e002, 0x05e003, &konamigt_irq_enable_w },
	{ 0x05e004, 0x05e005, MWA_NOP},	/* bit 8 of the word probably triggers IRQ on sound board */
	{ 0x060000, 0x067fff, MWA_BANK6, &ram },	/* WORK RAM */
	{ -1 }  /* end of table */
};


static struct MemoryReadAddress gx400_readmem[] =
{
	{ 0x000000, 0x00ffff, MRA_ROM },
	{ 0x010000, 0x01ffff, MRA_RAM },
	{ 0x020000, 0x027ff9, gx400_sharedram_r },
	{ 0x027ffa, 0x027fff, gx400_sharedram_nosoundfix_r },
	{ 0x030000, 0x03ffff, nemesis_characterram_r },
	{ 0x050000, 0x0503ff, MRA_RAM },
	{ 0x050400, 0x0507ff, MRA_RAM },
	{ 0x050800, 0x050bff, MRA_RAM },
	{ 0x050c00, 0x050fff, MRA_RAM },
	{ 0x052000, 0x053fff, nemesis_videoram1_r },
	{ 0x054000, 0x055fff, nemesis_videoram2_r },
	{ 0x056000, 0x056fff, MRA_RAM },
	{ 0x057000, 0x057fff, MRA_RAM },
	{ 0x05a000, 0x05afff, paletteram_word_r },
	{ 0x05c402, 0x05c403, input_port_4_r },	/* DSW0 */
	{ 0x05c404, 0x05c405, input_port_5_r },	/* DSW1 */
	{ 0x05c406, 0x05c407, input_port_3_r },	/* TEST */
	{ 0x05cc00, 0x05cc01, input_port_0_r },	/* IN0 */
	{ 0x05cc02, 0x05cc03, input_port_1_r },	/* IN1 */
	{ 0x05cc04, 0x05cc05, input_port_2_r },	/* IN2 */
	{ 0x060000, 0x07ffff, MRA_RAM },
	{ 0x080000, 0x0cffff, MRA_ROM },
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress gx400_writemem[] =
{
	{ 0x000000, 0x00ffff, MWA_ROM },
	{ 0x010000, 0x01ffff, MWA_RAM },
	{ 0x020000, 0x027fff, gx400_sharedram_w },
	{ 0x030000, 0x03ffff, nemesis_characterram_w, &nemesis_characterram, &nemesis_characterram_size },
	{ 0x050000, 0x0503ff, MWA_RAM, &nemesis_xscroll1 },
	{ 0x050400, 0x0507ff, MWA_RAM, &nemesis_xscroll2 },
	{ 0x050800, 0x050bff, MWA_RAM },
	{ 0x050c00, 0x050fff, MWA_RAM, &nemesis_yscroll },
	{ 0x051000, 0x051fff, MWA_NOP },		/* used, but written to with 0's */
	{ 0x052000, 0x053fff, nemesis_videoram1_w, &nemesis_videoram1 },	/* VRAM 1 */
	{ 0x054000, 0x055fff, nemesis_videoram2_w, &nemesis_videoram2 },	/* VRAM 2 */
	{ 0x056000, 0x056fff, MWA_RAM, &spriteram, &spriteram_size },
	{ 0x057000, 0x057fff, MWA_RAM},										/* needed for twinbee */
	{ 0x05a000, 0x05afff, paletteram_xBBBBBGGGGGRRRRR_word_w, &paletteram },
	{ 0x05c000, 0x05c001, nemesis_soundlatch_w },
	{ 0x05c800, 0x05c801, watchdog_reset_w },	/* probably */
	{ 0x05e000, 0x05e001, &gx400_irq2_enable_w },	/* ?? */
	{ 0x05e002, 0x05e003, &gx400_irq1_enable_w },	/* ?? */
	{ 0x05e004, 0x05e005, MWA_NOP},	/* bit 8 of the word probably triggers IRQ on sound board */
	{ 0x05e008, 0x05e009, MWA_NOP },	/* IRQ acknowledge??? */
	{ 0x05e00e, 0x05e00f, &gx400_irq4_enable_w },	/* ?? */
	{ 0x060000, 0x07ffff, MWA_RAM, &ram },
	{ 0x080000, 0x0cffff, MWA_ROM },
	{ -1 }  /* end of table */
};

static struct MemoryReadAddress rf2_gx400_readmem[] =
{
	{ 0x000000, 0x00ffff, MRA_ROM },
	{ 0x010000, 0x01ffff, MRA_RAM },
	{ 0x020000, 0x027fff, gx400_sharedram_r },
	{ 0x030000, 0x03ffff, nemesis_characterram_r },
	{ 0x050000, 0x0503ff, MRA_RAM },
	{ 0x050400, 0x0507ff, MRA_RAM },
	{ 0x050800, 0x050bff, MRA_RAM },
	{ 0x050c00, 0x050fff, MRA_RAM },
	{ 0x052000, 0x053fff, nemesis_videoram1_r },
	{ 0x054000, 0x055fff, nemesis_videoram2_r },
	{ 0x056000, 0x056fff, MRA_RAM },
	{ 0x05a000, 0x05afff, paletteram_word_r },
	{ 0x05c402, 0x05c403, input_port_4_r },	/* DSW0 */
	{ 0x05c404, 0x05c405, input_port_5_r },	/* DSW1 */
	{ 0x05c406, 0x05c407, input_port_3_r },	/* TEST */
	{ 0x05cc00, 0x05cc01, input_port_0_r },	/* IN0 */
	{ 0x05cc02, 0x05cc03, input_port_1_r },	/* IN1 */
	{ 0x05cc04, 0x05cc05, input_port_2_r },	/* IN2 */
	{ 0x060000, 0x067fff, MRA_RAM },
	{ 0x070000, 0x070001, konamigt_input_r },
	{ 0x080000, 0x0cffff, MRA_ROM },
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress rf2_gx400_writemem[] =
{
	{ 0x000000, 0x00ffff, MWA_ROM },
	{ 0x010000, 0x01ffff, MWA_RAM },
	{ 0x020000, 0x027fff, gx400_sharedram_w },
	{ 0x030000, 0x03ffff, nemesis_characterram_w, &nemesis_characterram, &nemesis_characterram_size },
	{ 0x050000, 0x0503ff, MWA_RAM, &nemesis_xscroll1 },
	{ 0x050400, 0x0507ff, MWA_RAM, &nemesis_xscroll2 },
	{ 0x050800, 0x050bff, MWA_RAM },
	{ 0x050c00, 0x050fff, MWA_RAM, &nemesis_yscroll },
	{ 0x051000, 0x051fff, MWA_NOP },		/* used, but written to with 0's */
	{ 0x052000, 0x053fff, nemesis_videoram1_w, &nemesis_videoram1 },	/* VRAM 1 */
	{ 0x054000, 0x055fff, nemesis_videoram2_w, &nemesis_videoram2 },	/* VRAM 2 */
	{ 0x056000, 0x056fff, MWA_RAM, &spriteram, &spriteram_size },
	{ 0x05a000, 0x05afff, paletteram_xBBBBBGGGGGRRRRR_word_w, &paletteram },
	{ 0x05c000, 0x05c001, nemesis_soundlatch_w },
	{ 0x05c800, 0x05c801, watchdog_reset_w },	/* probably */
	{ 0x05e000, 0x05e001, &gx400_irq2_enable_w },	/* ?? */
	{ 0x05e002, 0x05e003, &gx400_irq1_enable_w },	/* ?? */
	{ 0x05e004, 0x05e005, MWA_NOP}, /*	bit 8 of the word probably triggers IRQ on sound board */
	{ 0x05e008, 0x05e009, MWA_NOP },	/* IRQ acknowledge??? */
	{ 0x05e00e, 0x05e00f, &gx400_irq4_enable_w },	/* ?? */
	{ 0x060000, 0x067fff, MWA_RAM, &ram },	/* WORK RAM */
	{ 0x080000, 0x0cffff, MWA_ROM },
	{ -1 }  /* end of table */
};

static struct MemoryReadAddress gx400_sound_readmem[] =
{
	{ 0x0000, 0x1fff, MRA_ROM },
	{ 0x4000, 0x7fff, MRA_RAM },
	{ 0xe001, 0xe001, soundlatch_r },
	{ 0xe086, 0xe086, AY8910_read_port_0_r },
	{ 0xe205, 0xe205, AY8910_read_port_1_r },
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress gx400_sound_writemem[] =
{
	{ 0x0000, 0x1fff, MWA_ROM },
	{ 0x4000, 0x7fff, MWA_RAM, &gx400_shared_ram },
	{ 0xe006, 0xe006, AY8910_control_port_0_w },
	{ 0xe106, 0xe106, AY8910_write_port_0_w },
	{ 0xe005, 0xe005, AY8910_control_port_1_w },
	{ 0xe405, 0xe405, AY8910_write_port_1_w },
	{ -1 }  /* end of table */
};

/******************************************************************************/

static struct MemoryReadAddress salamand_readmem[] =
{
	{ 0x000000, 0x07ffff, MRA_ROM },  /* ROM BIOS */
	{ 0x080000, 0x087fff, MRA_BANK1 },
	{ 0x090000, 0x091fff, paletteram_word_r },
	{ 0x0c0002, 0x0c0003, input_port_3_r },	/* DSW0 */
	{ 0x0c2000, 0x0c2001, input_port_0_r },	/* Coins, start buttons, test mode */
	{ 0x0c2002, 0x0c2003, input_port_1_r },	/* IN1 */
	{ 0x0c2004, 0x0c2005, input_port_2_r },	/* IN2 */
	{ 0x0c2006, 0x0c2007, input_port_4_r },	/* DSW1 */
	{ 0x100000, 0x101fff, nemesis_videoram1_r },
	{ 0x102000, 0x103fff, nemesis_videoram2_r },
	{ 0x120000, 0x12ffff, nemesis_characterram_r },
	{ 0x180000, 0x180fff, MRA_BANK7 },
	{ 0x190000, 0x1903ff, gx400_xscroll1_r },
	{ 0x190400, 0x1907ff, gx400_xscroll2_r },
	{ 0x190800, 0x191fff, gx400_yscroll_r },
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress salamand_writemem[] =
{
	{ 0x000000, 0x07ffff, MWA_ROM },
	{ 0x080000, 0x087fff, MWA_BANK1 },
	{ 0x090000, 0x091fff, salamander_palette_w, &paletteram },
	{ 0x0A0000, 0x0A0001, nemesis_irq_enable_w },          /* irq enable */
	{ 0x0C0000, 0x0C0001, salamand_soundlatch_w },
	{ 0x0C0004, 0x0C0005, MWA_NOP },        /* Watchdog at $c0005 */
	{ 0x100000, 0x101fff, nemesis_videoram1_w, &nemesis_videoram1 },	/* VRAM 1 */
	{ 0x102000, 0x103fff, nemesis_videoram2_w, &nemesis_videoram2 },	/* VRAM 2 */
	{ 0x120000, 0x12ffff, nemesis_characterram_w, &nemesis_characterram, &nemesis_characterram_size },
	{ 0x180000, 0x180fff, MWA_BANK7, &spriteram, &spriteram_size },		/* more sprite ram ??? */
	{ 0x190000, 0x1903ff, gx400_xscroll1_w, &nemesis_xscroll1 },
	{ 0x190400, 0x1907ff, gx400_xscroll2_w, &nemesis_xscroll2 },
	{ 0x190800, 0x191fff, gx400_yscroll_w, &nemesis_yscroll },
	{ -1 }  /* end of table */
};

static int wd_read(int offset)
{
	static int a=1;
	a^= 1;
	return a;
}

static struct MemoryReadAddress sal_sound_readmem[] =
{
	{ 0x0000, 0x7fff, MRA_ROM },
	{ 0x8000, 0x87ff, MRA_RAM },
	{ 0xa000, 0xa000, soundlatch_r },
	{ 0xb000, 0xb00d, K007232_ReadReg },
	{ 0xc001, 0xc001, YM2151_status_port_0_r },
	{ 0xe000, 0xe000, wd_read }, /* watchdog?? */
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress sal_sound_writemem[] =
{
	{ 0x0000, 0x7fff, MWA_ROM },
	{ 0x8000, 0x87ff, MWA_RAM },
	{ 0xb000, 0xb00d, K007232_WriteReg },
	{ 0xc000, 0xc000, YM2151_register_port_0_w },
	{ 0xc001, 0xc001, YM2151_data_port_0_w },

	{ -1 }  /* end of table */
};

/******************************************************************************/

#define GX400_COINAGE_DIP \
	PORT_DIPNAME( 0x0f, 0x0f, "Coin A", IP_KEY_NONE )				\
	PORT_DIPSETTING(    0x02, "4 Coins/1 Credit" )		\
	PORT_DIPSETTING(    0x05, "3 Coins/1 Credit" )		\
	PORT_DIPSETTING(    0x08, "2 Coins/1 Credit" )		\
	PORT_DIPSETTING(    0x04, "3 Coins/2 Credits" )		\
	PORT_DIPSETTING(    0x01, "4 Coins/3 Credits" )		\
	PORT_DIPSETTING(    0x0f, "1 Coin/1 Credit" )		\
	PORT_DIPSETTING(    0x03, "3 Coins/4 Credits" )		\
	PORT_DIPSETTING(    0x07, "2 Coins/3 Credits" )		\
	PORT_DIPSETTING(    0x0e, "1 Coin/2 Credits" )		\
	PORT_DIPSETTING(    0x06, "2 Coins/5 Credits" )		\
	PORT_DIPSETTING(    0x0d, "1 Coin/3 Credits" )		\
	PORT_DIPSETTING(    0x0c, "1 Coin/4 Credits" )		\
	PORT_DIPSETTING(    0x0b, "1 Coin/5 Credits" )		\
	PORT_DIPSETTING(    0x0a, "1 Coin/6 Credits" )		\
	PORT_DIPSETTING(    0x09, "1 Coin/7 Credits" )		\
	PORT_DIPSETTING(    0x00, "Free Play" )				\
	PORT_DIPNAME( 0xf0, 0xf0, "Coin B", IP_KEY_NONE )				\
	PORT_DIPSETTING(    0x20, "4 Coins/1 Credit" )		\
	PORT_DIPSETTING(    0x50, "3 Coins/1 Credit" )		\
	PORT_DIPSETTING(    0x80, "2 Coins/1 Credit" )		\
	PORT_DIPSETTING(    0x40, "3 Coins/2 Credits" )		\
	PORT_DIPSETTING(    0x10, "4 Coins/3 Credits" )		\
	PORT_DIPSETTING(    0xf0, "1 Coin/1 Credit" )		\
	PORT_DIPSETTING(    0x30, "3 Coins/4 Credits" )		\
	PORT_DIPSETTING(    0x70, "2 Coins/3 Credits" )		\
	PORT_DIPSETTING(    0xe0, "1 Coin/2 Credits" )		\
	PORT_DIPSETTING(    0x60, "2 Coins/5 Credits" )		\
	PORT_DIPSETTING(    0xd0, "1 Coin/3 Credits" )		\
	PORT_DIPSETTING(    0xc0, "1 Coin/4 Credits" )		\
	PORT_DIPSETTING(    0xb0, "1 Coin/5 Credits" )		\
	PORT_DIPSETTING(    0xa0, "1 Coin/6 Credits" )		\
	PORT_DIPSETTING(    0x90, "1 Coin/7 Credits" )		\
	PORT_DIPSETTING(    0x00, "Disable" )

INPUT_PORTS_START( nemesis_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_START2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON3 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON1 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON3 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* TEST */
	PORT_DIPNAME( 0x01, 0x01, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x02, "Version", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Normal" )
	PORT_DIPSETTING(    0x00, "Vs" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE,0 )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* DSW0 */
	GX400_COINAGE_DIP

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x03, 0x03, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x03, "3" )
	PORT_DIPSETTING(    0x02, "4" )
	PORT_DIPSETTING(    0x01, "5" )
	PORT_DIPSETTING(    0x00, "7" )
	PORT_DIPNAME( 0x04, 0x00, "Cabinet", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "Upright" )
	PORT_DIPSETTING(    0x04, "Cocktail" )
	PORT_DIPNAME( 0x18, 0x18, "Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x10, "30k" )
	PORT_DIPSETTING(    0x18, "50k and every 100k" )
	PORT_DIPSETTING(    0x08, "50k" )
	PORT_DIPSETTING(    0x00, "100k" )
	PORT_DIPNAME( 0x60, 0x60, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x60, "Easy" )
	PORT_DIPSETTING(    0x40, "Normal" )
	PORT_DIPSETTING(    0x20, "Difficult" )
	PORT_DIPSETTING(    0x00, "Very Difficult" )
	PORT_DIPNAME( 0x80, 0x00, "Demo Sounds", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END

INPUT_PORTS_START( nemesuk_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_START2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON3 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON1 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON3 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* TEST */
	PORT_DIPNAME( 0x01, 0x01, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x02, "Version", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Normal" )
	PORT_DIPSETTING(    0x00, "Vs" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE,0 )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* DSW0 */
	GX400_COINAGE_DIP

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x03, 0x02, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x03, "2" )
	PORT_DIPSETTING(    0x02, "3" )
	PORT_DIPSETTING(    0x01, "5" )
	PORT_DIPSETTING(    0x00, "7" )
	PORT_DIPNAME( 0x04, 0x00, "Cabinet", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "Upright" )
	PORT_DIPSETTING(    0x04, "Cocktail" )
	PORT_DIPNAME( 0x18, 0x18, "Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x18, "20k and every 70k" )
	PORT_DIPSETTING(    0x10, "30k and every 80k" )
	PORT_DIPSETTING(    0x08, "20k" )
	PORT_DIPSETTING(    0x00, "30k" )
	PORT_DIPNAME( 0x60, 0x60, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x60, "Easy" )
	PORT_DIPSETTING(    0x40, "Normal" )
	PORT_DIPSETTING(    0x20, "Difficult" )
	PORT_DIPSETTING(    0x00, "Very Difficult" )
	PORT_DIPNAME( 0x80, 0x00, "Demo Sounds", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END


/* This needs to be sorted */
INPUT_PORTS_START( konamigt_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_START2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* IN1 */
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON3 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON1 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_BUTTON4 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON3 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* TEST */
	PORT_DIPNAME( 0x01, 0x01, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x02, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE,0 )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* DSW0 */
	GX400_COINAGE_DIP

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x01, 0x01, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x02, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x04, 0x04, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x08, 0x08, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x08, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x30, 0x30, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x30, "Easy" )
	PORT_DIPSETTING(    0x20, "Normal" )
	PORT_DIPSETTING(    0x10, "Difficult" )
	PORT_DIPSETTING(    0x00, "Very Difficult" )
	PORT_DIPNAME( 0x40, 0x40, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x40, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x80, 0x80, "Demo Sounds", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )


	PORT_START	/* IN6 */
	PORT_ANALOG ( 0xff, 0x40, IPT_DIAL , 25, 0, 0x00, 0x7f )
INPUT_PORTS_END

/* This needs to be sorted */
INPUT_PORTS_START( rf2_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_START2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* IN1 */
	PORT_BIT( 0x10, IP_ACTIVE_LOW,  IPT_BUTTON3 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON1 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_BUTTON4 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON3 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* TEST */
	PORT_DIPNAME( 0x01, 0x01, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x02, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE,0 )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* DSW0 */
	GX400_COINAGE_DIP

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x01, 0x00, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x00, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x04, 0x00, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x08, 0x00, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x08, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x30, 0x30, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x30, "Easy" )
	PORT_DIPSETTING(    0x20, "Normal" )
	PORT_DIPSETTING(    0x10, "Difficult" )
	PORT_DIPSETTING(    0x00, "Very Difficult" )
	PORT_DIPNAME( 0x40, 0x00, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x40, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x80, 0x00, "Demo Sounds", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )


	PORT_START	/* IN6 */
	PORT_ANALOG ( 0xff, 0x40, IPT_DIAL , 25, 0, 0x00, 0x7f )
INPUT_PORTS_END

INPUT_PORTS_START( gwarrior_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_BUTTON3 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN |  IPF_8WAY |IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* TEST */
	PORT_DIPNAME( 0x01, 0x01, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x02, "Version", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Normal" )
	PORT_DIPSETTING(    0x00, "Vs" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE,0 )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* DSW0 */
	GX400_COINAGE_DIP

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x03, 0x01, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x03, "1" )
	PORT_DIPSETTING(    0x02, "2" )
	PORT_DIPSETTING(    0x01, "3" )
	PORT_DIPSETTING(    0x00, "7" )
	PORT_DIPNAME( 0x04, 0x00, "Unknown", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPNAME( 0x18, 0x18, "Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x18, "30k and every 70k" )
	PORT_DIPSETTING(    0x10, "40k and every 80k" )
	PORT_DIPSETTING(    0x08, "50k and every 100k" )
	PORT_DIPSETTING(    0x00, "100k and every 100k" )
	PORT_DIPNAME( 0x60, 0x60, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x60, "Easy" )
	PORT_DIPSETTING(    0x40, "Normal" )
	PORT_DIPSETTING(    0x20, "Difficult" )
	PORT_DIPSETTING(    0x00, "Very Difficult" )
	PORT_DIPNAME( 0x80, 0x80, "Demo Sounds" , IP_KEY_NONE)
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END


INPUT_PORTS_START( gradius_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON3 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* TEST */
	PORT_DIPNAME( 0x01, 0x01, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_DIPNAME( 0x02, 0x02, "Version", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Normal" )
	PORT_DIPSETTING(    0x00, "Vs" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE,0 )
	PORT_DIPSETTING(    0x04, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* DSW0 */
	GX400_COINAGE_DIP

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x03, 0x01, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x03, "3" )
	PORT_DIPSETTING(    0x02, "4" )
	PORT_DIPSETTING(    0x01, "5" )
	PORT_DIPSETTING(    0x00, "7" )
	PORT_DIPNAME( 0x04, 0x00, "Cabinet", IP_KEY_NONE )
	PORT_DIPSETTING(    0x00, "Upright" )
	PORT_DIPSETTING(    0x04, "Cocktail" )
	PORT_DIPNAME( 0x18, 0x18, "Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x18, "20k and every 70k" )
	PORT_DIPSETTING(    0x08, "20k only" )
	PORT_DIPSETTING(    0x10, "30k and every 80k" )
	PORT_DIPSETTING(    0x00, "30k only" )
	PORT_DIPNAME( 0x60, 0x60, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x60, "Easy" )
	PORT_DIPSETTING(    0x40, "Normal" )
	PORT_DIPSETTING(    0x20, "Difficult" )
	PORT_DIPSETTING(    0x00, "Very Difficult" )
	PORT_DIPNAME( 0x80, 0x00, "Demo Sounds", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END

INPUT_PORTS_START( salamand_input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_START2 )
	PORT_DIPNAME( 0x20, 0x20, "Flip Screen", IP_KEY_NONE )
	PORT_DIPSETTING(    0x20, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BITX(    0x80, 0x80, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Test Mode", OSD_KEY_F2, 0,0 )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_8WAY| IPF_8WAY  )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON1 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON3 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_BUTTON3 | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* DSW0 */
	GX400_COINAGE_DIP

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x03, 0x03, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x03, "2" )
	PORT_DIPSETTING(    0x02, "3" )
	PORT_DIPSETTING(    0x01, "5" )
	PORT_DIPSETTING(    0x00, "7" )
	PORT_DIPNAME( 0x04, 0x04, "Coin Slots", IP_KEY_NONE )
	PORT_DIPSETTING(    0x04, "One" )
	PORT_DIPSETTING(    0x00, "Two" )
	PORT_DIPNAME( 0x18, 0x00, "Max Credit", IP_KEY_NONE )
	PORT_DIPSETTING(    0x18, "1" )
	PORT_DIPSETTING(    0x10, "3" )
	PORT_DIPSETTING(    0x08, "5" )
	PORT_DIPSETTING(    0x00, "9" )
	PORT_DIPNAME( 0x60, 0x60, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x60, "Easy" )
	PORT_DIPSETTING(    0x40, "Medium" )
	PORT_DIPSETTING(    0x20, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	PORT_DIPNAME( 0x80, 0x00, "Demo Sounds", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "Off" )
	PORT_DIPSETTING(    0x00, "On" )
INPUT_PORTS_END

/******************************************************************************/

static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	2048,	/* 2048 characters */
	4,	/* 4 bits per pixel */
	{ 0, 1, 2, 3 }, /* the two bitplanes are merged in the same nibble */
	{ 0*4, 1*4, 2*4, 3*4, 4*4, 5*4, 6*4, 7*4 },
	{ 0*32, 1*32, 2*32, 3*32, 4*32, 5*32, 6*32, 7*32 },
	32*8     /* every char takes 32 consecutive bytes */
};

static struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	512,	/* 512 sprites */
	4,	/* 4 bits per pixel */
	{ 0, 1, 2, 3 }, /* the two bitplanes are merged in the same nibble */
	{ 0*4, 1*4, 2*4, 3*4, 4*4, 5*4, 6*4, 7*4,
			8*4, 9*4, 10*4, 11*4, 12*4, 13*4, 14*4, 15*4 },
	{ 0*64, 1*64, 2*64, 3*64, 4*64, 5*64, 6*64, 7*64,
			8*64, 9*64, 10*64, 11*64, 12*64, 13*64, 14*64, 15*64 },
	128*8     /* every sprite takes 128 consecutive bytes */
};

static struct GfxLayout spritelayout3216 =
{
	32,16,	/* 32*16 sprites */
	256,	/* 256 sprites */
	4,	/* 4 bits per pixel */
	{ 0, 1, 2, 3 }, /* the two bitplanes are merged in the same nibble */
	{ 0*4, 1*4, 2*4, 3*4, 4*4, 5*4, 6*4, 7*4,
			8*4, 9*4, 10*4, 11*4, 12*4, 13*4, 14*4, 15*4,
		   16*4,17*4, 18*4, 19*4, 20*4, 21*4, 22*4, 23*4,
		   24*4,25*4, 26*4, 27*4, 28*4, 29*4, 30*4, 31*4},
	{ 0*128, 1*128, 2*128, 3*128, 4*128, 5*128, 6*128, 7*128,
			8*128, 9*128, 10*128, 11*128, 12*128, 13*128, 14*128, 15*128 },
	256*8     /* every sprite takes 128 consecutive bytes */
};

static struct GfxLayout spritelayout1632 =
{
	16,32,	/* 16*32 sprites */
	256,	/* 256 sprites */
	4,	/* 4 bits per pixel */
	{ 0, 1, 2, 3 }, /* the two bitplanes are merged in the same nibble */
	{ 0*4, 1*4, 2*4, 3*4, 4*4, 5*4, 6*4, 7*4,
			8*4, 9*4, 10*4, 11*4, 12*4, 13*4, 14*4, 15*4},
	{ 0*64,  1*64,  2*64,  3*64,  4*64,  5*64,  6*64,  7*64,
	  8*64,  9*64, 10*64, 11*64, 12*64, 13*64, 14*64, 15*64,
	 16*64, 17*64, 18*64, 19*64, 20*64, 21*64, 22*64, 23*64,
	 24*64, 25*64, 26*64, 27*64, 28*64, 29*64, 30*64, 31*64},
	256*8     /* every sprite takes 128 consecutive bytes */
};

static struct GfxLayout spritelayout3232 =
{
	32,32,	/* 32*32 sprites */
	129,	/* 128 sprites */
	4,	/* 4 bits per pixel */
	{ 0, 1, 2, 3 }, /* the two bitplanes are merged in the same nibble */
	{ 0*4, 1*4, 2*4, 3*4, 4*4, 5*4, 6*4, 7*4,
			8*4, 9*4, 10*4, 11*4, 12*4, 13*4, 14*4, 15*4,
		   16*4,17*4, 18*4, 19*4, 20*4, 21*4, 22*4, 23*4,
		   24*4,25*4, 26*4, 27*4, 28*4, 29*4, 30*4, 31*4},
	{ 0*128, 1*128, 2*128, 3*128, 4*128, 5*128, 6*128, 7*128,
			8*128,  9*128, 10*128, 11*128, 12*128, 13*128, 14*128, 15*128,
		   16*128, 17*128, 18*128, 19*128, 20*128, 21*128, 22*128, 23*128,
		   24*128, 25*128, 26*128, 27*128, 28*128, 29*128, 30*128, 31*128},
	512*8     /* every sprite takes 128 consecutive bytes */
};

static struct GfxLayout spritelayout816 =
{
	8,16,	/* 16*16 sprites */
	1024,	/* 512 sprites */
	4,	/* 4 bits per pixel */
	{ 0, 1, 2, 3 }, /* the two bitplanes are merged in the same nibble */
	{ 0*4, 1*4, 2*4, 3*4, 4*4, 5*4, 6*4, 7*4},
	{ 0*32, 1*32, 2*32, 3*32, 4*32, 5*32, 6*32, 7*32,
			8*32, 9*32, 10*32, 11*32, 12*32, 13*32, 14*32, 15*32 },
	64*8     /* every sprite takes 128 consecutive bytes */
};


static struct GfxDecodeInfo gfxdecodeinfo[] =
{
    { 0, 0x0, &charlayout,   0, 0x80 },	/* the game dynamically modifies this */
    { 0, 0x0, &spritelayout, 0, 0x80 },	/* the game dynamically modifies this */
    { 0, 0x0, &spritelayout3216, 0, 0x80 },	/* the game dynamically modifies this */
    { 0, 0x0, &spritelayout816, 0, 0x80 },	/* the game dynamically modifies this */
    { 0, 0x0, &spritelayout3232, 0, 0x80 },	/* the game dynamically modifies this */
    { 0, 0x0, &spritelayout1632, 0, 0x80 },	/* the game dynamically modifies this */
	{ -1 }
};

/******************************************************************************/

static struct AY8910interface ay8910_interface =
{
	2,	/* 2 chip */
	14318000/8,	/* 1.78975 Mhz?? */
	{ 0x20ff, 0x20ff },
	{ nemesis_portA_r, 0 },
	{ 0, 0 },
	{ 0, 0 },
	{ 0, 0 }
};

static void sound_irq(int state)
{
/* Interrupts _are_ generated, I wonder where they go.. */
/*cpu_cause_interrupt(1,Z80_IRQ_INT);*/
}

static struct YM2151interface ym2151_interface =
{
	1,
	3579545,
	{ 45 },
	{ sound_irq }
};

static struct VLM5030interface vlm5030_interface =
{
    3579545,    /* master clock  */
    70,        /* volume        */
    3,         /* memory region  */
    0,         /* VCU            */
};

static struct K007232_interface k007232_interface =
{
	4,4,  /* memory regions */
	12 /* volume */
};

/******************************************************************************/

static struct MachineDriver nemesis_machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_M68000,
			14318180/2,	/* ??? guess */
			0,
			readmem,writemem,0,0,
			nemesis_interrupt,1
		},
		{
			CPU_Z80 | CPU_AUDIO_CPU,
			3579545,	/* 3.579545 MHz */
			2,
			sound_readmem,sound_writemem,0,0,
			ignore_interrupt,1	/* interrupts are triggered by the main CPU */
		},
	},

	60, DEFAULT_REAL_60HZ_VBLANK_DURATION,
	1,	/* 1 CPU slice per frame - interleaving is forced when a sound command is written */
	nemesis_init_machine,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	gfxdecodeinfo,
	2048, 2048,
	0,

	VIDEO_TYPE_RASTER | VIDEO_MODIFIES_PALETTE,
	0,
	nemesis_vh_start,
	nemesis_vh_stop,
	nemesis_vh_screenrefresh,

	/* sound hardware */
	0,0,0,0,
	{
		{
			SOUND_AY8910,
			&ay8910_interface
		}
	}
};


static struct MachineDriver konamigt_machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_M68000,
			14318180/2,	/* ??? guess */
			0,
			konamigt_readmem,konamigt_writemem,0,0,
			konamigt_interrupt,2
		},
		{
			CPU_Z80 | CPU_AUDIO_CPU,
			3579545,	/* 3.579545 MHz */
			2,
			sound_readmem,sound_writemem,0,0,
			ignore_interrupt,1	/* interrupts are triggered by the main CPU */
		},
	},

	60, DEFAULT_REAL_60HZ_VBLANK_DURATION,
	1,	/* 1 CPU slice per frame - interleaving is forced when a sound command is written */
	nemesis_init_machine,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	gfxdecodeinfo,
	2048, 2048,
	0,

	VIDEO_TYPE_RASTER | VIDEO_MODIFIES_PALETTE,
	0,
	nemesis_vh_start,
	nemesis_vh_stop,
	nemesis_vh_screenrefresh,

	/* sound hardware */
	0,0,0,0,
	{
		{
			SOUND_AY8910,
			&ay8910_interface
		}
	}
};

static struct MachineDriver salamand_machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_M68000,
			10000000,       /* 8 Mhz?? */
			0,
			salamand_readmem,salamand_writemem,0,0,
			salamand_interrupt,1
		},
		{
			CPU_Z80 | CPU_AUDIO_CPU,
			3579545,	/* 3.579545 MHz */
			2,
			sal_sound_readmem,sal_sound_writemem,0,0,
			ignore_interrupt,0
		},
	},

	60, DEFAULT_60HZ_VBLANK_DURATION,
	1,	/* 1 CPU slice per frame - interleaving is forced when a sound command is written */
	nemesis_init_machine,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	gfxdecodeinfo,
	2048, 2048,
	0,

	VIDEO_TYPE_RASTER | VIDEO_MODIFIES_PALETTE | VIDEO_UPDATE_BEFORE_VBLANK,
	0,
	nemesis_vh_start,
	nemesis_vh_stop,
	salamand_vh_screenrefresh,

	/* sound hardware */
	SOUND_SUPPORTS_STEREO,0,0,0,
	{
		{
			SOUND_VLM5030,
			&vlm5030_interface
		},
		{
			SOUND_K007232,
			&k007232_interface,
		},
		{
			SOUND_YM2151,
			&ym2151_interface
		}
	}
};

static struct MachineDriver gx400_machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_M68000,
			14318180/2,	/* ??? guess */
			0,
			gx400_readmem,gx400_writemem,0,0,
			gx400_interrupt,3
		},
		{
			CPU_Z80 | CPU_AUDIO_CPU,
			3579545,	/* 3.579545 MHz */
			2,
			gx400_sound_readmem,gx400_sound_writemem,0,0,
			nmi_interrupt,1	/* interrupts are triggered by the main CPU */
		},
	},

	60, DEFAULT_REAL_60HZ_VBLANK_DURATION,
	1,	/* 1 CPU slice per frame - interleaving is forced when a sound command is written */
	nemesis_init_machine,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	gfxdecodeinfo,
	2048, 2048,
	0,

	VIDEO_TYPE_RASTER | VIDEO_MODIFIES_PALETTE,
	0,
	nemesis_vh_start,
	nemesis_vh_stop,
	nemesis_vh_screenrefresh,

	/* sound hardware */
	0,0,0,0,
	{
		{
			SOUND_AY8910,
			&ay8910_interface
		}
	}
};

static struct MachineDriver rf2_gx400_machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_M68000,
			14318180/2,	/* ??? guess */
			0,
			rf2_gx400_readmem,rf2_gx400_writemem,0,0,
			gx400_interrupt,3
		},
		{
			CPU_Z80 | CPU_AUDIO_CPU,
			3579545,	/* 3.579545 MHz */
			2,
			gx400_sound_readmem,gx400_sound_writemem,0,0,
			nmi_interrupt,1	/* interrupts are triggered by the main CPU */
		},
	},

	60, DEFAULT_REAL_60HZ_VBLANK_DURATION,
	1,	/* 1 CPU slice per frame - interleaving is forced when a sound command is written */
	nemesis_init_machine,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	gfxdecodeinfo,
	2048, 2048,
	0,

	VIDEO_TYPE_RASTER | VIDEO_MODIFIES_PALETTE,
	0,
	nemesis_vh_start,
	nemesis_vh_stop,
	nemesis_vh_screenrefresh,

	/* sound hardware */
	0,0,0,0,
	{
		{
			SOUND_AY8910,
			&ay8910_interface
		}
	}
};

/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( nemesis_rom )
	ROM_REGION(0x40000)    /* 4 * 64k for code and rom */
	ROM_LOAD_EVEN ( "12a_01.bin",   0x00000, 0x8000, 0x35ff1aaa )
	ROM_LOAD_ODD  ( "12c_05.bin",   0x00000, 0x8000, 0x23155faa )
	ROM_LOAD_EVEN ( "13a_02.bin",   0x10000, 0x8000, 0xac0cf163 )
	ROM_LOAD_ODD  ( "13c_06.bin",   0x10000, 0x8000, 0x023f22a9 )
	ROM_LOAD_EVEN ( "14a_03.bin",   0x20000, 0x8000, 0x8cefb25f )
	ROM_LOAD_ODD  ( "14c_07.bin",   0x20000, 0x8000, 0xd50b82cb )
	ROM_LOAD_EVEN ( "15a_04.bin",   0x30000, 0x8000, 0x9ca75592 )
	ROM_LOAD_ODD  ( "15c_08.bin",   0x30000, 0x8000, 0x03c0b7f5 )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "09c_snd.bin",  0x0000, 0x4000, 0x26bf9636 )
ROM_END

ROM_START( nemesuk_rom )
	ROM_REGION(0x40000)    /* 4 * 64k for code and rom */
	ROM_LOAD_EVEN ( "12a_01.uk",    0x00000, 0x8000, 0xe1993f91 )
	ROM_LOAD_ODD  ( "12c_05.uk",    0x00000, 0x8000, 0xc9761c78 )
	ROM_LOAD_EVEN ( "13a_02.uk",    0x10000, 0x8000, 0xf6169c4b )
	ROM_LOAD_ODD  ( "13c_06.uk",    0x10000, 0x8000, 0xaf58c548 )
	ROM_LOAD_EVEN ( "14a_03.bin",   0x20000, 0x8000, 0x8cefb25f )
	ROM_LOAD_ODD  ( "14c_07.bin",   0x20000, 0x8000, 0xd50b82cb )
	ROM_LOAD_EVEN ( "15a_04.uk",    0x30000, 0x8000, 0x322423d0 )
	ROM_LOAD_ODD  ( "15c_08.uk",    0x30000, 0x8000, 0xeb656266 )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "09c_snd.bin",  0x0000, 0x4000, 0x26bf9636 )
ROM_END

ROM_START( konamigt_rom )
	ROM_REGION(0x40000)    /* 4 * 64k for code and rom */
	ROM_LOAD_EVEN ( "c01.rom",      0x00000, 0x8000, 0x56245bfd )
	ROM_LOAD_ODD  ( "c05.rom",      0x00000, 0x8000, 0x8d651f44 )
	ROM_LOAD_EVEN ( "c02.rom",      0x10000, 0x8000, 0x3407b7cb )
	ROM_LOAD_ODD  ( "c06.rom",      0x10000, 0x8000, 0x209942d4 )
	ROM_LOAD_EVEN ( "b03.rom",      0x20000, 0x8000, 0xaef7df48 )
	ROM_LOAD_ODD  ( "b07.rom",      0x20000, 0x8000, 0xe9bd6250 )
	ROM_LOAD_EVEN ( "b04.rom",      0x30000, 0x8000, 0x94bd4bd7 )
	ROM_LOAD_ODD  ( "b08.rom",      0x30000, 0x8000, 0xb7236567 )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "b09.rom",      0x00000, 0x4000, 0x539d0c49 )
ROM_END

ROM_START( rf2_rom )
	ROM_REGION(0xc0000)    /* 5 * 64k for code and rom */
	ROM_LOAD_EVEN ( "400-a06.15l",  0x00000, 0x08000, 0xb99d8cff )
	ROM_LOAD_ODD  ( "400-a04.10l",  0x00000, 0x08000, 0xd02c9552 )
	ROM_LOAD_EVEN ( "561-a07.17l",  0x80000, 0x20000, 0xed6e7098 )
	ROM_LOAD_ODD  ( "561-a05.12l",  0x80000, 0x20000, 0xdfe04425 )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "400-e03.5l",       0x00000, 0x2000, 0xa5a8e57d )
ROM_END

ROM_START( twinbee_rom )
	ROM_REGION(0xc0000)    /* 5 * 64k for code and rom */
	ROM_LOAD_EVEN ( "400-a06.15l",  0x00000, 0x08000, 0xb99d8cff )
	ROM_LOAD_ODD  ( "400-a04.10l",  0x00000, 0x08000, 0xd02c9552 )
	ROM_LOAD_EVEN ( "412-a07.17l",  0x80000, 0x20000, 0xd93c5499 )
	ROM_LOAD_ODD  ( "412-a05.12l",  0x80000, 0x20000, 0x2b357069 )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "400-e03.5l",       0x00000, 0x2000, 0xa5a8e57d )
ROM_END

ROM_START( gradius_rom )
	ROM_REGION(0xc0000)    /* 5 * 64k for code and rom */
	ROM_LOAD_EVEN ( "400-a06.15l",  0x00000, 0x08000, 0xb99d8cff )
	ROM_LOAD_ODD  ( "400-a04.10l",  0x00000, 0x08000, 0xd02c9552 )
	ROM_LOAD_EVEN ( "456-a07.17l",  0x80000, 0x20000, 0x92df792c )
	ROM_LOAD_ODD  ( "456-a05.12l",  0x80000, 0x20000, 0x5cafb263 )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "400-e03.5l",       0x00000, 0x2000, 0xa5a8e57d )
ROM_END

ROM_START( gwarrior_rom )
	ROM_REGION(0xc0000)    /* 5 * 64k for code and rom */
	ROM_LOAD_EVEN ( "400-a06.15l",  0x00000, 0x08000, 0xb99d8cff )
	ROM_LOAD_ODD  ( "400-a04.10l",  0x00000, 0x08000, 0xd02c9552 )
	ROM_LOAD_EVEN ( "578-a07.17l",  0x80000, 0x20000, 0x0aedacb5 )
	ROM_LOAD_ODD  ( "578-a05.12l",  0x80000, 0x20000, 0x76240e2e )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "400-e03.5l",       0x00000, 0x2000, 0xa5a8e57d )
ROM_END

ROM_START( salamand_rom )
	ROM_REGION(0x80000)    /* 64k for code */
	ROM_LOAD_EVEN ( "18b.bin",  0x00000, 0x10000, 0xa42297f9 )
	ROM_LOAD_ODD  ( "18c.bin",  0x00000, 0x10000, 0xf9130b0a )
	ROM_LOAD_EVEN ( "17b.bin",  0x40000, 0x20000, 0xe5caf6e6 )
	ROM_LOAD_ODD  ( "17c.bin",  0x40000, 0x20000, 0xc2f567ea )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "11j.bin", 0x00000, 0x8000, 0x5020972c )

	ROM_REGION(0x4000)    /* VLM5030 data? */
	ROM_LOAD  ( "8g.bin",  0x00000, 0x4000, 0xf9ac6b82 )

	ROM_REGION(0x20000)    /* 007232 data */
	ROM_LOAD  ( "10a.bin", 0x00000, 0x20000, 0x09fe0632 )
ROM_END

ROM_START( lifefrce_rom )
	ROM_REGION(0x80000)    /* 64k for code */
	ROM_LOAD_EVEN ( "587-k02.bin",  0x00000, 0x10000, 0x4a44da18 )
	ROM_LOAD_ODD  ( "587-k05.bin",  0x00000, 0x10000, 0x2f8c1cbd )
	ROM_LOAD_EVEN ( "17b.bin",      0x40000, 0x20000, 0xe5caf6e6 )
	ROM_LOAD_ODD  ( "17c.bin",      0x40000, 0x20000, 0xc2f567ea )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "587-k09.bin",      0x00000, 0x8000, 0x2255fe8c )

	ROM_REGION(0x4000)    /* VLM5030 data? */
	ROM_LOAD  ( "587-k08.bin",      0x00000, 0x4000, 0x7f0e9b41 )

	ROM_REGION(0x20000)    /* 007232 data */
	ROM_LOAD  ( "10a.bin",      0x00000, 0x20000, 0x09fe0632 )
ROM_END

ROM_START( lifefrcj_rom )
	ROM_REGION(0x80000)    /* 64k for code */
	ROM_LOAD_EVEN ( "587-n02.bin",  0x00000, 0x10000, 0x235dba71 )
	ROM_LOAD_ODD  ( "587-n05.bin",  0x00000, 0x10000, 0x054e569f )
	ROM_LOAD_EVEN ( "587-n03.bin",  0x40000, 0x20000, 0x9041f850 )
	ROM_LOAD_ODD  ( "587-n06.bin",  0x40000, 0x20000, 0xfba8b6aa )

	ROM_REGION_DISPOSE(0x1000)      /* temporary space for graphics (disposed after conversion) */
	/* empty memory region - not used by the game, but needed because the main */
	/* core currently always frees region #1 after initialization. */

	ROM_REGION(0x10000)    /* 64k for sound */
	ROM_LOAD  ( "587-n09.bin",      0x00000, 0x8000, 0xe8496150 )

	ROM_REGION(0x4000)    /* VLM5030 data? */
	ROM_LOAD  ( "587-k08.bin",      0x00000, 0x4000, 0x7f0e9b41 )

	ROM_REGION(0x20000)    /* 007232 data */
	ROM_LOAD  ( "10a.bin",      0x00000, 0x20000, 0x09fe0632 )
ROM_END

/******************************************************************************/

static int nemesis_hiload(void)
{
	void *f;

	/* check if the hi score table has already been initialized */
	if (memcmp(&ram[0x0098],"\x05\x00\x00\x73",4) == 0)
	{
		if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,0)) != 0)
		{
			osd_fread(f,&ram[0x5010],8*18);
			ram[0x0098] = ram[0x501a];
			ram[0x0099] = ram[0x501b];
			ram[0x009a] = ram[0x501c];
			ram[0x009b] = ram[0x501d];
			osd_fclose(f);
		}
		return 1;
	}
	else return 0;  /* we can't load the hi scores yet */
}

static void nemesis_hisave(void)
{
	void *f;

	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,1)) != 0)
	{
		osd_fwrite(f,&ram[0x5010],8*18);
		osd_fclose(f);
	}
}

/******************************************************************************/

struct GameDriver nemesis_driver =
{
	__FILE__,
	0,
	"nemesis",
	"Nemesis (hacked?)",
	"1985",
	"Konami",
	"Allard van der Bas",
	0,
	&nemesis_machine_driver,
	0,

	nemesis_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	nemesis_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	nemesis_hiload,nemesis_hisave
};

struct GameDriver nemesuk_driver =
{
	__FILE__,
	&nemesis_driver,
	"nemesuk",
	"Nemesis (UK)",
	"1985",
	"Konami",
	"Allard van der Bas",
	0,
	&nemesis_machine_driver,
	0,

	nemesuk_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	nemesuk_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	nemesis_hiload,nemesis_hisave
};

struct GameDriver konamigt_driver =
{
	__FILE__,
	0,
	"konamigt",
	"Konami GT",
	"1985",
	"Konami",
	"Allard van der Bas\nAndrew Prime",
	0,
	&konamigt_machine_driver,
	0,

	konamigt_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	konamigt_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	0,0
};

struct GameDriver rf2_driver =
{
	__FILE__,
	&konamigt_driver,
	"rf2",
	"RF2",
	"1985",
	"Konami",
	"Allard van der Bas\nNicola Salmoria\nAndrew Prime",
	0,
	&rf2_gx400_machine_driver,
	0,

	rf2_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	rf2_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	0,0
};

struct GameDriver twinbee_driver =
{
	__FILE__,
	0,
	"twinbee",
	"TwinBee",
	"1985",
	"Konami",
	"Allard van der Bas\nNicola Salmoria\nAndrew Prime",
	0,
	&gx400_machine_driver,
	0,

	twinbee_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	gwarrior_input_ports,

	0, 0, 0,
	ORIENTATION_ROTATE_90,

	0,0
};

struct GameDriver gradius_driver =
{
	__FILE__,
	&nemesis_driver,
	"gradius",
	"Gradius",
	"1985",
	"Konami",
	"Allard van der Bas\nNicola Salmoria\nAndrew Prime",
	0,
	&gx400_machine_driver,
	0,

	gradius_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	gradius_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	0,0
};

struct GameDriver gwarrior_driver =
{
	__FILE__,
	0,
	"gwarrior",
	"Galactic Warriors",
	"1985",
	"Konami",
	"Allard van der Bas\nNicola Salmoria\nAndrew Prime",
	0,
	&gx400_machine_driver,
	0,

	gwarrior_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	gwarrior_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	0,0
};

struct GameDriver salamand_driver =
{
	__FILE__,
	0,
	"salamand",
	"Salamander",
	"1986",
	"Konami",
	"Bryan McPhail (Salamander)\nAllard van der Bas (GX400 driver)\nNicola Salmoria (GX400 driver)\nAndrew Prime (GX400 driver)",
	0,
	&salamand_machine_driver,
	0,

	salamand_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	salamand_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	0,0
};

struct GameDriver lifefrce_driver =
{
	__FILE__,
	&salamand_driver,
	"lifefrce",
	"Lifeforce (US)",
	"1986",
	"Konami",
	"Bryan McPhail (Salamander)\nAllard van der Bas (GX400 driver)\nNicola Salmoria (GX400 driver)\nAndrew Prime (GX400 driver)",
	0,
	&salamand_machine_driver,
	0,

	lifefrce_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	salamand_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	0,0
};

struct GameDriver lifefrcj_driver =
{
	__FILE__,
	&salamand_driver,
	"lifefrcj",
	"Lifeforce (Japan)",
	"1986",
	"Konami",
	"Bryan McPhail (Salamander)\nAllard van der Bas (GX400 driver)\nNicola Salmoria (GX400 driver)\nAndrew Prime (GX400 driver)",
	0,
	&salamand_machine_driver,
	0,

	lifefrcj_rom,
	0, 0,
	0,
	0,      /* sound_prom */

	salamand_input_ports,

	0, 0, 0,
	ORIENTATION_DEFAULT,

	0,0
};
